# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package SR_cli_rc;
#"@(#)05   1.9   src/rsct/registry/cli/pm/SR_cli_rc.pm.perl, srcli, rsct_rpyxh, rpyxht1f3 8/5/00 04:09:00"
######################################################################
#                                                                    #
# Package: SR_cli_rc.pm                                              #
#                                                                    #
# Description:                                                       #
#   This package contains return codes used for the PERL             #
#   System Registry CLI commands. Each return code can be            #
#   referenced separately, or as a whole using the 'return_codes'    #
#   EXPORT_TAG.                                                      #
#                                                                    #
# Examples:                                                          #
#   use SR_cli_rc qw(SR_CLI_BAD_OPERAND SR_CLI_BAD_FLAG)             #
#   - exports only 2 of the return codes for use in the calling      #
#     program.                                                       #
#                                                                    #
#   use SR_cli_rc qw(:return_codes)                                  #
#   - exports all return codes included in the EXPORT_TAG            #
#     return_codes. (the ':' is needed to access the tag)            #
#                                                                    #
#--------------------------------------------------------------------#
#                                                                    #
# Inputs:                                                            #
#                                                                    #
# Outputs:                                                           #
#                                                                    #
# External References:                                               #
#   Perl Modules:   constant, Exporter                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000929 HGJ 38317: Initial delivery.                              #
######################################################################

use Exporter ();
use constant;
@ISA = qw(Exporter);
@EXPORT_OK = qw(    SR_CLI_SUCCESS
                    SR_CLI_REGISTRY_ERROR
                    SR_CLI_ERROR
                    SR_CLI_BAD_FLAG
                    SR_CLI_BAD_OPERAND
                    SR_CLI_USER_ERROR
);

#--------------------------------------------------------------------#
# EXPORT TAGS is used to refer to the return codes as a group        #
#--------------------------------------------------------------------#

%EXPORT_TAGS = (
return_codes => [qw(SR_CLI_SUCCESS
                    SR_CLI_REGISTRY_ERROR
                    SR_CLI_ERROR
                    SR_CLI_BAD_FLAG
                    SR_CLI_BAD_OPERAND
                    SR_CLI_USER_ERROR
)]
); # end %EXPORT_TAGS


#--------------------------------------------------------------------#
# Return Code Definitions                                            #
#--------------------------------------------------------------------#
use constant SR_CLI_SUCCESS         => 0;
use constant SR_CLI_REGISTRY_ERROR  => 1;
use constant SR_CLI_ERROR           => 2;       
use constant SR_CLI_BAD_FLAG        => 3;
use constant SR_CLI_BAD_OPERAND     => 4;
use constant SR_CLI_USER_ERROR      => 5;


#--------------------------------------------------------------------#
# End of File                                                        #
#--------------------------------------------------------------------#
